# Bounding Box Annotation of Musical Measures

## About this data set

We provide measure annotations for several hundred pages of sheet music, including the complete cycle "Der Ring des Nibelungen" by Richard Wagner, selected piano sonatas by Ludwig von Beethoven, the complete cycle "Winterreise" by Franz Schubert, as well as selected pieces from the Carus publishing house.

This data set is accompanied by the following short paper.

Frank Zalkow, Angel Villar Corrales, TJ Tsai, Vlora Arifi-Müller, and Meinard Müller:
Tools for Semi-Automatic Bounding Box Annotation of Musical Measures in Sheet Music.
In Demos and Late Breaking News of the International Society for Music Information Retrieval Conference (ISMIR), 2019.

The following website is hosting the data set.

https://www.audiolabs-erlangen.de/resources/MIR/2019-ISMIR-LBD-Measures

Some stats for the data set:

* 43 different musical pieces (considering a movement/song/act as individual piece)
* 940 sheet music images
* 24,329 bounding box annotations of musical measures

## Licenses

The measure annotations are under a [Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0)](https://creativecommons.org/licenses/by-nc-sa/4.0/) license. Please cite the above mentioned short paper if you use the annotations.

The sheet music images for the musical pieces are under the following licenes:

| Pieces     | License                                                                       |
|:-----------|:------------------------------------------------------------------------------|
| Beethoven  | Public Domain (source: IMSLP, Universal Edition, editor: Heinrich Schenker)   |
| Chorissimo | Provided by kind permission of Carus.                                         |
| Schubert   | Public Domain (source: IMSLP, Peters, editor: Max Friedlaender)               |
| Wagner     | Public Domain (source: IMSLP, B. Schott's Söhne, editor: Richard Kleinmichel) |

## File Structure

The data set has the following file structure:

    MeasureBoundingBoxAnnotations
    ├── README.md
    ├── 2019_ZalkowVTAM_BoundingBox_ISMIR-LBD.pdf
    ├── jupyter
    │   └── visualize_bounding_box.ipynb
    ├── Beethoven_Op026-01
    │   ├── Beethoven_Op026-01.csv
    │   └── img
    │       ├── Beethoven_Op026-01_000.png
    ⋮      ⋮
    │       └── Beethoven_Op026-01_007.png
    └── Wagner_WWV086D-3
        ├── Wagner_WWV086D-3.csv
        └── img
            ├── Wagner_WWV086D_174.png
            ⋮
            └── Wagner_WWV086D_244.png

Each musical piece is represented by a top-level directory (e.g., `Beethoven_Op026-01` or `Wagner_WWV086D-3`). Inside such a piece-level directory there is a CSV file with annotations (see below) and a directory named `img` with image files in PNG format. Furthermore, the top-level contains a README file, the pdf of the short paper, and a directory named `jupyter`. This directory contains an Anaconda environment file and a Jupyter notebook file that shows how to visualize bounding boxes on sheet music images with Python code.

## CSV Files

All CSV files are standard files with comma separation and have the following columns:

| Column   | Explanation                                     |
|:---------|:------------------------------------------------|
| Measure  | Label for Measure                               |
| RowIndex | Number of the musical staff on the current page |
| X        | X position in pixel                             |
| Y        | Y position in pixel                             |
| Height   | Height in pixel                                 |
| Width    | Width in pixel                                  |
| Image    | Filename of image                               |

## Changelog

2020-01-06:
  * There was a bug in our Wagner CSV export pipeline, which have been fixed. Thanks to Ken Leidal for reporting the bug!
  * Replaced all CSV files for Wagner.
  * Corrected the total number of bounding boxes in this README file.

2020-01-07:
  * Added Jupyter notebook file that shows how to visualize bounding boxes on sheet music images. Thanks again to Ken Leidal!
  * Added the PDF of the full paper.

## Acknowledgements

The International Audio Laboratories Erlangen are a joint institution of the Friedrich-Alexander-Universität Erlangen-Nürnberg (FAU) and Fraunhofer Institute for Integrated Circuits IIS. This work was supported by the German Research Foundation (MU 2686/12-1, MU 2686/7-1, MU 2686/7-2). We thank Johannes Graulich from Carus publishing house for providing sheet music and audio examples for our demonstrators.
