## SAOC Dataset 

The *SAOC Dataset* is part of the *SEBASS-DB*, a collection of subjective ratings on the perceived quality of separated audio soure signals. It contains the results on listening tests on assessing the *Basic Audio Quality* of such signals.
 
### Collection of the subjective ratings.

The subjective ratings were collected using [MUSHRA](https://en.wikipedia.org/wiki/MUSHRA) [(see ITU-R BS1534.3)](https://www.itu.int/dms_pubrec/itu-r/rec/bs/R-REC-BS.1534-3-201510-I!!PDF-E.pdf) based listening tests.
The [webMUSHRA](https://www.audiolabs-erlangen.de/resources/webMUSHRA) software was used for some of the listening tests. It provides a graphical user interface for the participants of the listening test.

The test procedure can be explained as follows:
#### Method of presentation
In each trial of a listening test, the participants blindly rated the following test signals in comparison to the known (ideal) reference source signal:

- separated versions of the source signal from different separation algorithms
- the original source signal (hidden reference)
- the signal mixture (as anchor signal)

The subjects had the possibility to switch instantaneously between each of the presented signals and to set playback loops. The items were presented via headphones in a quite listening room.

Experienced listeners took part in the listening test.

#### Method of quantification
The listener had to grade the unknown signals on the MUSHRA scale (0..100). The numerical scale is equally divided into five segments and semantical annotated ("bad", "poor", "fair", "good", "excellent"). The question asked to the listener was: "Grade the [Basic Audio Quality](https://www.itu.int/dms_pubrec/itu-r/rec/bs/R-REC-BS.1534-3-201510-I!!PDF-E.pdf) of the items under test with respect to the reference signal. Any perceived differences between the reference and the other signal must be interpreted as an impairment."


### License
Due to the different origin of the audio signals and the subjective ratings, different licenses apply to these data.

- The subjective grades are licensed under a [Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License](https://creativecommons.org/licenses/by-nc-sa/4.0/).
- The audio asignals are licensed under a [Creative Commons Attribution-NonCommercial-ShareAlike 2.0 license](https://creativecommons.org/licenses/by-nc-sa/2.0/). See also the file "Licence_AudioSignals.txt".
- When using this dataset of subjective ratings, the following paper must be referenced: "An Efficient Model for Estimating Subjective Quality of Separated Audio Source Signals" by (link:fau/assistant/kastner/ text: Thorsten Kastner) and (link:fau/professor/herre/ text:Jürgen Herre), 2019 IEEE Workshop on Applications of Signal Processing to Audio and Acoustics (WASPAA 2019), New Paltz, New York. 


All audio signals had been transformed to 2 channel stereo, 16 Bit, 48kHz Sampling rate and PCM in WAVE format. The audio format of the [original audio signals](https://www.irisa.fr/metiss/SASSEC07/?show=results) may differ.

### Audio files and listener ratings Structuring

The listener ratings are provided as csv-files with the fields:  
*Testname*, *Listener name*, *Test Trial*, *Test Condition*,  *Rating score*. 

Example:  

Testname | Listener | Trial | Condition | Rating score
--- | --- | --- | --- | ---
SASSEC | Listener\_14 | female\_inst\_sim\_1 | orig | 100 

The structure of the folder containing the audio files is organized as follows:  
*Signals/Test Condition/{test Trial}.wav*  

Example:  
./Signals_1/orig/female\_inst\_sim\_1.wav  
./Signals_1/orig/female\_inst\_sim\_2.wav  
./Signals_1/orig/female\_inst\_sim\_3.wav  
...

The listening test was split into 3 sessions to avoid fatigue of the listener. For each of the session a csv-file is given (SAOC_1_anonymized.csv,..., SAOC_3_anonymized.csv) and one folder containing the listening test signals (Signals_1,..., Signals_3).

### Mapping name of listening test condition to algorithm/serparation system
The test conditions are numbered starting from "Algo1" up to "Algo10". The number refers to the separation system participated in the *First Stereo Audio Source Separation Evaluation Campaign*

To map number to separation system/algorithm:

1. Take the number, e.g. "1" from "Algo1"
2. Open the website https://www.irisa.fr/metiss/SASSEC07/?show=results
3. Have a look at the cell in the result matrix containing the same algorithm number. ("Algo1" -> "Algorithm 1 D. Barry")

The additional ending "\_SAOC" like in "Algo1\_SAOC" refers to the fact that the blindly separated source signals from, in this example, Algo1 are used as source estimates for the object based audio coding scheme [SAOC](http://www.aes.org/e-lib/browse.cfm?elib=14507) to render on the end-user side only the desired target singal from the signal mixture.  For more details see [The Influence of the Rendering Architecture on the Subjective Performance of Blind Source Separation Algorithms](http://www.aes.org/e-lib/browse.cfm?elib=15093). 



**The listening test results have been used in the following study**

```
@conference{ksr_BSS_SAOC,
Address = {New York},
Author = {Thorsten Kastner},
Booktitle = {Audio Engineering Society Convention 127},
Url = {http://www.aes.org/e-lib/browse.cfm?elib=15093},
Month = {Oct},
Number = {7898},
Title = {The Influence of the Rendering Architecture on the Subjective Performance of Blind Source Separation Algorithms},
Year = {2009}
}
```


Version 1.0 Oct. 2019
