function IRs = computeIRs(c, Fs, room_size, source, mic_pos, T60,  varargin)

%---------------------------%
%     Function inputs       %
%---------------------------%

%\ 'c' ... Speed of sound
%\ 'Fs' ... Sampling frequency [Hz]
%\ 'room_size' ... (1x3) length x width x height of the room [m]
%\ 'source' ... (3 x numberOfSources), source positions
%\ 'mic_pos' ...(3 x microphonesPerArray), microphone positions [m]
%\ 'T60' ... Reverberation time [s]
%\ varargin{1} ... Reflection order. If not provided, the default is -1.
%\ varargin{2} ... a string naming the directivity pattern, see rir_generator.pdf
%\ varargin{3} ... look direction of a directive microphone 

%---------------------------%
%     Function outputs      %
%---------------------------%

%\ IRs ... The computed impulse responses(samples x numMics x numSources)

%=============================================%

if nargin<7
    refOrder = -1;
else
    refOrder = varargin{1};
end

if nargin<8
    micPattern = 'omnidirectional';
    micLookDir = [0 0];
else
    micPattern = varargin{2};
    micLookDir = varargin{3};
end



for sidx = 1:size(source,2)  
      IRs(:,:,sidx) =  rir_generator(c, Fs, mic_pos.' ,source(:,sidx)',room_size, T60, T60*Fs, micPattern, refOrder, length(room_size), micLookDir);
end

IRs = permute(IRs,[2 1 3]); % IRs: samples x mics x source 

