function [HNR] = HNR_estimate(time_block,F0,Fs)
%HNR_ESTIMATE Estimate the harmonic to noise ratio of a signal
%  time_block: time signal block
%  Fs:         sampling frequency
%  F0:         fundamental frequency (NOTE: could become NaN!)
%  HNR:        HNR estimate

% handle invalid NaN values for F0 gracefully
if isnan(F0) || F0 == 0
    HNR = NaN;
    return
end

HNR=-1;
