%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB VISUALIZATION TUTORIAL
%
% Version: 1
% Date: 14.05.20013
% Programmer: Jonathan Driedger, Thomas Prtzlich
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% CLEAN UP AND PREPARATION
clc;
close all;
clear;

% Some Data for visualization is prepared in data.mat
load data.mat;

%% EXAMPLE: NOVELTY CURVE

% basic plot
figure;
plot(noveltyCurve);

% Add a time axis. The vector timeAxis_noveltyCurve specifies the time of
% each sample point of novektyCurve
figure;
plot(timeAxis_noveltyCurve,noveltyCurve);

% Add a title and axis labels
title('Novelty Curve');
xlabel('Time in [sec]');

% Show just the relevant data range
axis tight;

% Plot additional data in the existing Figure
hold on;
p = plot(timeAxis_noveltyCurve,noveltyCurve_avg,'r--','LineWidth',2);
set(p,'Color',[0.2 0.5 0.2]);
plot(noveltyCurve_peaks(:,1),noveltyCurve_peaks(:,2),'or');

% set visible range
xlim([65 105]);

% 'reset' visible range
xlim([-inf inf]);
xlim([65 105]);

% add a legend
leg = legend('Novelty Curve','Average Novelty Curve','Novelty Peaks');
set(leg,'Location','NorthWest');

% for some reason, somtimes the surrounding box is not displayed properly
% in the printed version of the figure after having used 'hold on'. To
% recover the box use this command
box on;

% print the Figure in an eps/png file
set(gcf,'PaperUnits','centimeters');
set(gcf,'PaperPosition',[1   10   26  15]); %[left, bottom, width, height]
print('-depsc2','image_noveltyCurve1');

% Note that, since eps is a vector graphic format, by changing the 'size' 
% of the printed out version, the main diference is that the size of lables 
% and text is scaled. This is an easy way to bring all font sizes to the 
% desired size at once.
set(gcf,'PaperPosition',[1   10   26  15]*0.7); %[left, bottom, width, height]
print('-depsc2','image_noveltyCurve2');

%% EXAMPLE: CENS FEATURE
% In opposite to the commonly used 'surf' command to visualize a
% data-matrix, the 'imagesc' command ommits the generation of the, for our
% purpose, unnecessary 3D data and is therefore much more efficient in
% terms of memory usage. Additionally, imagesc does not produce lines
% between the data cells automatically what is a desireable behaviour when
% visualizing large matrices

% Compare
figure; surf(f_CENS);view(2);
figure; imagesc(f_CENS);

% Add a time axis
figure; imagesc(timeAxis_CENS,1:12,f_CENS);

% Add a title and axis labels
title('CENS Feature');
xlabel('Time in [sec]');

% Make the y axis go from bottom to top instead of top to bottom
axis xy;

% Add labels for the Chroma names. We first make sure that every row has a
% 'tick', meaning a marker which can have a label
set(gca,'YTick',1:12);
%afterwards we set the labels
set(gca,'YTickLabel',chromaNames);

% Change the colormap
colormap(hot);

% Add a colorbar
cb = colorbar;

% Make the Colorbar thinner
c = get(gca,'Position');
a = get(cb,'Position');
set(cb,'Position',[a(1) a(2) a(3)/2 a(4)])
set(gca,'Position',c);

% print the Figure in an eps/png file
set(gcf,'PaperUnits','centimeters');
set(gcf,'PaperPosition',[1   10   26  15]); %[left, bottom, width, height]
print('-depsc2','image_CENS');

%% EXAMPLE: SELF SIMILARITY MATRIX

SSM = f_CENS' * f_CENS;
figure;
imagesc(timeAxis_CENS,timeAxis_CENS,SSM);
axis xy;
axis square; % ensure that axes are of same length
xlabel('Time in [sec]');
ylabel('Time in [sec]');
colormap(gray);
myColormap = [repmat([0 0 0],50,1);gray; repmat([1 0 0],5,1)]; %building our own colorbar
colormap(myColormap);
colorbar;

set(gcf,'PaperUnits','centimeters');
set(gcf,'PaperPosition',[1   10   30  20]); %[left, bottom, width, height]
print('-depsc2','image_SSM');

%% EXAMPLE: DTW

%we can also create a figure at a certain position and of a certain size on
%the screen.
figure('Position',[10 10 1500 600]);

% subplot allows you to place more than one plot in a figure. The first two
% arguments specify the number of panes in y and x direction, the third
% number specifies the 'index'of the current pane that you want to draw to.
subplot(1,2,1);

imagesc(costMatrix);
axis xy;
colormap(hot);
colorbar;
title('Cost Matrix')
hold on;
plot(warpingpath(:,1),warpingpath(:,2),'LineWidth',2,'Color',[0 0 0]);
plot(warpingpath(:,1),warpingpath(:,2),'LineWidth',1,'Color',[1 1 1]);
xlim([400 540]);
ylim([500 640]);

% Plot a rectangle into the plot
r = rectangle('Position',[460 540 40 50]);%[left, bottom, width, height]
set(r,'EdgeColor',[0.4 1 0.4],'LineWidth',3,'Curvature',0.2);

subplot(1,2,2);
imagesc(accumulatedCostMatrix);
axis xy;
colorbar;
title('Accumulated Cost Matrix')
hold on;
plot(warpingpath(:,1),warpingpath(:,2),'LineWidth',2,'Color',[0 0 0]);
plot(warpingpath(:,1),warpingpath(:,2),'LineWidth',1,'Color',[1 1 1]);
xlim([400 540]);
ylim([500 640]);
r = rectangle('Position',[460 540 40 50]);%[left, bottom, width, height]
set(r,'EdgeColor',[0.4 1 0.4],'LineWidth',3,'Curvature',0.2);

% Changing the colormap to improve the visualization in this case won't 
% work, since one can only have one colormap per figure. DON'T try to use
% different colormaps in one fgure with subplots! It's a mess!
myColormap = [hot(64); repmat([1 1 1],150,1)]; %building our own colorbar
colormap(myColormap);

colormap(hot);

% Instead of changing the colorbar, we can also simply change the range the
% colorbar is mapped to
set(gca,'clim',[30 100]);

set(gcf,'PaperUnits','centimeters');
set(gcf,'PaperPosition',[1   10   26  15]); %[left, bottom, width, height]
print('-depsc2','image_DTW');
