%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Waveform Superposition
%
%  Sonification
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all;

fs = 4096;
duration = 1;  %seconds
t=(0:1:(duration*fs-1))/fs;

w=220;theta=0; ampl=0.1;
f=ampl*sin(2*pi*(w*t-theta));		
                        
w=660; theta=0; ampl=0.1;
g=ampl*sin(2*pi*(w*t-theta));

e = randn(1,length(t));	  %white N(0,1)-distributed noise
sigma = 0.1;		      %noise level = Variance of sigma*e
h=sigma*e;                %noisy signal


s = 1*f + 0.1*g + 0*h;

figure;
plot(t,s)
a = max(abs(s));
axis([0,duration,-1.1*a,1.1*a])
xlabel('time t')
title('signal f + 0.8 * g + 0.5 * h')
sound(s,fs);

