%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Waveform Sinusoidal
%
% Visualization
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all;

t=(0:1:512-1)/256;
w=1;theta=0; ampl=1;
%w=3; theta=0; ampl=1;
%w=3; theta=0.5; ampl=0.8;
f=ampl*sin(2*pi*(w*t-theta));
figure;
plot(t,f)
axis([0,2,-1.6,1.6])
xlabel('time t')
%set(gca,'xtick',[])
title(['\omega=',num2str(w),', \theta=',num2str(theta), ', A=' num2str(ampl)])

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Waveform Sinusoidal
%
% Frequency + Sonification
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all;

fs = 4096;
duration = 1;  %seconds
t=(0:1:(duration*fs-1))/fs;
p = 71;
w = 2^((p-69)/12) * 440;
theta=0; 
ampl=0.1;
% 10 * ampli -> 100 * intensity -> 20 dB increase
f=ampl*sin(2*pi*(w*t-theta));
figure;
plot(t,f)
a = max(abs(f));
axis([0,duration,-1.1*a,1.1*a])
xlabel('time t')
title(['\omega=',num2str(w),', \theta=',num2str(theta), ', A=' num2str(ampl)])

sound(f,fs);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Waveform Sinusoidal
%
% Sonification + dB
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all;

fs = 4096;
duration = 1;  %seconds
t=(0:1:(duration*fs-1))/fs;
w=440;
theta=0; 
ampl=0.1;
% 10 * ampli -> 100 * intensity -> 20 dB increase
f=ampl*sin(2*pi*(w*t-theta));
figure;
plot(t,f)
a = max(abs(f));
axis([0,duration,-1.1*a,1.1*a])

energy = sum(f.^2)/fs;
power = energy/duration;
area = 1;
intensity = power/area;
intensityReference = 10^(-12);
soundLevel = 10 * log10(intensity/intensityReference);

xlabel(['Sound level = ',num2str(soundLevel),' [dB]']);
title(['\omega=',num2str(w),', \theta=',num2str(theta), ', A=' num2str(ampl)])
sound(f,fs);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Waveform Superposition
%
%  Visualization
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all;

%%
fs = 4410;
%fs = 256;
duration = 4;  %seconds
t=(0:1:(duration*fs-1))/fs;

figure;
subplot(2,2,1)
w=1;theta=0; ampl=1;
f=ampl*sin(2*pi*(w*t-theta));		
plot(t,f)               
axis([0,4,-1.2,1.2])
xlabel('time t')
set(gca,'xtick',[])
title('signal f')
%sound(f,fs);                

subplot(2,2,2)
w=3; theta=0.2; ampl=1;
g=ampl*sin(2*pi*(w*t-theta));
plot(t,g)               
axis([0,4,-1.2,1.2])
xlabel('time t')
set(gca,'xtick',[])
title('signal g')                
%sound(g,fs);   

subplot(2,2,3)
e = randn(1,length(t));	  %white N(0,1)-distributed noise
sigma = 0.3;		      %noise level = Variance of sigma*e
h=sigma*e;                %noisy signal
plot(t,h)               
axis([0,4,-1.2,1.2])
title('signal h')
%sound(h,fs)
  
subplot(2,2,4)
s = f + 0.8*g + 0.5 * h;
plot(t,s)  
axis([0,4,-2.2,2.2])
xlabel('time t')
title('signal f + 0.8 * g + 0.5 * h')
%sound(s,fs)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Waveform Superposition
%
%  Sonification
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all;

fs = 4096;
duration = 1;  %seconds
t=(0:1:(duration*fs-1))/fs;

w=220;theta=0; ampl=0.1;
f=ampl*sin(2*pi*(w*t-theta));		
                        
w=660; theta=0; ampl=0.1;
g=ampl*sin(2*pi*(w*t-theta));

e = randn(1,length(t));	  %white N(0,1)-distributed noise
sigma = 0.1;		      %noise level = Variance of sigma*e
h=sigma*e;                %noisy signal


s = 1*f + 1*g + 0.1*h;

figure;
plot(t,s)
a = max(abs(s));
axis([0,duration,-1.1*a,1.1*a])
xlabel('time t')
title('signal f + 0.8 * g + 0.5 * h')
sound(s,fs);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Waveform Audio Files
%
% Sonification 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all;

filename = 'Sys_tonleiter_CDur_langsam_BB_F.wav';
% C4 = 261.6 Hz, Period = 0.0038 [seconds]
% Exaplain: Superpostion, harmonics, ...

%filename = 'SYS_tonleiter1b_midi_helga.wav';
%filename = 'fk_zuerich_11025_stereo.wav';
%filename = 'fk_bonn_44100_mono.wav';
[f,fs] = wavread(filename);

t=(0:1:length(f)-1)/fs;
figure;
plot(t,f)
axis tight;
xlabel('time t')
title(filename,'Interpreter','none')
sound(f,fs);

