%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Approximation of Fourier transform by DFT of chirp function 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all hidden;

a=0;b=2;N=1280;t = a:(1/N)*(b-a):b-(1/(N*(b-a))); 
g=sin(6*pi*t.*t);		
                              
%[w,ghut,wmin,wmax]=ctft(a,b,N,t,g,0,128,1);
freq_max = 50;
[w,ghut,wmin,wmax]=ctft(a,b,N,t,g,0,freq_max,10);

printPaperPosition = [1   10   28  20]; %[left, bottom, width, height]

figure;
subplot(3,2,1)
plot(t,g)               
axis([a,b,-1.5,1.5])
xlabel('time t')

subplot(3,2,2)
plot(w,abs(ghut(wmin:wmax)),'r')  
axis([0,50,0,0.3])
xlabel('frequency \omega')

% T-Sampling of g and taking the first N samples 

T = 1/100; 
N = 200; 
a=0;b=2;L=b*(1/T);t = a:(1/L)*(b-a):b-(1/(L*(b-a))); 
g=(sin(6*pi*t.*t));

if N<=L
    g_N = g(1:N);
else
    g_N = zeros(1,N);
    g_N(1:L) = g;
end

subplot(3,2,3)
stem([1:N],g_N,'.b');
axis([1,N,-1.5,1.5])
xlabel('sample n')


% Computing the DFT of size N

ghut = T*fft(g_N);
subplot(3,2,4)
k_axis = (0:N-1);
stem(k_axis,abs(ghut),'.r')  
%plot(abs(ghut))  
axis([1,N,0,0.3])
xlabel('index k')

subplot(3,2,5)
k_axis = (0:N-1);
stem(k_axis,abs(ghut),'.r')  
%plot(k_axis,abs(ghut))
%plot(abs(ghut)) 
k_max = freq_max*T*N;
axis([1,k_max,0,0.3])
xlabel('index k')

subplot(3,2,6)
k_axis = (0:N-1);
%stem(k_axis,abs(ghut),'.r')  
plot(k_axis,abs(ghut),'r')
%plot(abs(ghut)) 
k_max = freq_max*T*N;
axis([1,k_max,0,0.3])
xlabel('index k')


printFile = 'FourierDFT_Chirp2_figure';
set(gcf,'PaperPosition',printPaperPosition); 
print('-dtiff',strcat(printFile));