%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Box function and Fourier transform
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear;
close all hidden;

a=-1;b=1;N=256;t = a:(1/N)*(b-a):b-(1/(N*(b-a))); 

g=[zeros(1,N/4),boxcar(N/2)',zeros(1,N/4)];

c=-4;d=4;
[w,ghut,wmin,wmax]=ctft(a,b,N,t,g,c,d,8);

figure;
subplot(2,2,1)
plot(t,g)               
axis([a,b,0,1.1])
%title('Box function f')

subplot(2,2,2)
plot(w,abs(ghut(wmin:wmax)))  
axis([c,d,0,1.1])
%title('Absoulte value |\hat{f}|')

subplot(2,2,3)
plot(w,real(ghut(wmin:wmax)))  
axis([c,d,-1.1,1.1])
%title('re(F(f)) (sinc function)')


subplot(2,2,4)
plot(w,imag(ghut(wmin:wmax)))  
axis([c,d,-1.1,1.1])
%title('im(F(f))')


printPaperPosition = [1   10   22  14]; %[left, bottom, width, height]
printFile = 'FourierCT_box_figure01';
set(gcf,'PaperPosition',printPaperPosition); 
print('-dtiff',strcat(printFile));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%translation of box function

a=0;b=2;N=256;t = a:(1/N)*(b-a):b-(1/(N*(b-a))); 

g=[zeros(1,N/4),boxcar(N/2)',zeros(1,N/4)];

c=-4;d=4;
[w,ghut,wmin,wmax]=ctft(a,b,N,t,g,c,d,8);

figure;

subplot(2,2,1)
plot(t,g)               
axis([a,b,0,1.1])
%title('Box function f')

subplot(2,2,2)
plot(w,abs(ghut(wmin:wmax)))  
axis([c,d,0,1.1])
%title('Absolute value |F(f)|')

subplot(2,2,3)
plot(w,real(ghut(wmin:wmax)))  
axis([c,d,-1.1,1.1])
%title('re(F(f))')


subplot(2,2,4)
plot(w,imag(ghut(wmin:wmax)))  
axis([c,d,-1.1,1.1])
%title('im(F(f))')

printPaperPosition = [1   10   22  14]; %[left, bottom, width, height]
printFile = 'FourierCT_box_figure02';
set(gcf,'PaperPosition',printPaperPosition); 
print('-dtiff',strcat(printFile));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%translation of box function

a=10;b=12;N=256;t = a:(1/N)*(b-a):b-(1/(N*(b-a))); 

g=[zeros(1,N/4),boxcar(N/2)',zeros(1,N/4)];

c=-4;d=4;
[w,ghut,wmin,wmax]=ctft(a,b,N,t,g,c,d,8);

figure
subplot(2,2,1)
plot(t,g)               
axis([a,b,0,1.1])
%title('Box function f')

subplot(2,2,2)
plot(w,abs(ghut(wmin:wmax)))  
axis([c,d,0,1.1])
%title('Absolute value |F(f)|')

subplot(2,2,3)
plot(w,real(ghut(wmin:wmax)))  
axis([c,d,-1.1,1.1])
%title('re(F(f))')


subplot(2,2,4)
plot(w,imag(ghut(wmin:wmax)))  
axis([c,d,-1.1,1.1])
%title('im(F(f))')

printPaperPosition = [1   10   22  14]; %[left, bottom, width, height]
printFile = 'FourierCT_box_figure03';
set(gcf,'PaperPosition',printPaperPosition); 
print('-dtiff',strcat(printFile));
