%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Sinus overlayed with noise and Fourier transform
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all hidden;

a=0;b=10;N=1024;t = a:(1/N)*(b-a):b-(1/(N*(b-a)));

g=sin(2*pi*t) + 0.7*sin(10*pi*t);

 
[w,ghut,wmin,wmax]=ctft(a,b,N,t,g,0,7,16);

subplot(2,1,1)
plot(t,g)            
axis([a,b,-2.2,2.2])
xlabel('Time t')
%title('Chirp signal f(t)=sin(50*pi*t^2) on the interval [0:2]')

subplot(2,1,2)
plot(w,abs(ghut(wmin:wmax)))  
%plot(w,abs(ghut(wmin:wmax)).^2)  
xlabel('Frequency \omega')
%title('Spectral energy density |F(f)|^2')  


printPaperPosition = [1   10   22  14]; %[left, bottom, width, height]
printFile = 'FourierCT_Sine1_figure';
set(gcf,'PaperPosition',printPaperPosition); 
print('-dtiff',strcat(printFile));


%% sonification


N=22050;
b = 2;
t = 0:(1/N):b;
p = 440;

g=0.5*sin(p*2*pi*t) + 0.5*sin(p*5/4*2*pi*t);

wavplay(g,22050)
wavwrite(g, 22050,16, 'FourierCT_Sine1_Audio.wav')

                        
                        