%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Different samplings of cosine function
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all hidden;

printPaperPosition = [1   10   24  8]; %[left, bottom, width, height]

sr = 1024;
t=(0:1:sr)/sr;


figure;
w=8; theta=0; ampl=1;
f=ampl*cos(2*pi*w*t+theta);		
plot(t,f);               
axis([0,1,-1.4,1.4])
%xlabel('time t')
%title('\omega=1/256, \theta=0, A=1')
set(gcf,'PaperPosition',printPaperPosition);
print('-dtiff','Cosine_sampling_figure01');

      
figure;
plot(t,f);      
axis([0,1,-1.4,1.4])
hold;
sr = 50;
tsr = (0:1:sr)/sr;
fsr=ampl*cos(2*pi*w*tsr+theta);
stem(tsr,fsr,'r');
set(gcf,'PaperPosition',printPaperPosition);
print('-dtiff','Cosine_sampling_figure02');



figure;
plot(t,f);      
axis([0,1,-1.4,1.4])
hold;
sr = 32;
tsr = (0:1:sr)/sr;
fsr=ampl*cos(2*pi*w*tsr+theta);
stem(tsr,fsr,'r');
set(gcf,'PaperPosition',printPaperPosition);
print('-dtiff','Cosine_sampling_figure03');



figure;
plot(t,f);      
axis([0,1,-1.4,1.4])
hold;
sr = 16;
tsr = (0:1:sr)/sr;
fsr=ampl*cos(2*pi*w*tsr+theta);
stem(tsr,fsr,'r');
set(gcf,'PaperPosition',printPaperPosition);
print('-dtiff','Cosine_sampling_figure04');



figure;
plot(t,f);      
axis([0,1,-1.4,1.4])
hold;
sr = 10;
tsr = (0:1:sr)/sr;
fsr=ampl*cos(2*pi*w*tsr+theta);
stem(tsr,fsr,'r');
set(gcf,'PaperPosition',printPaperPosition);
print('-dtiff','Cosine_sampling_figure05');



