function [] = vis_timeFreqRep(specData,parameter)


if nargin < 2
    parameter = [];
end

if isfield(parameter,'name')==0 
    parameter.name = '';
end

if isfield(parameter,'featureResolution')==0 
    parameter.featureResolution = 1;
end
if isfield(parameter,'fs')==0 
    parameter.fs = 1;
end
if isfield(parameter,'imagerange')==0
   parameter.imagerange = 0;
end

T = (0:size(specData,2)-1)./parameter.featureResolution; % time in sec
F = (0:size(specData,1)-1)./size(specData,1)*parameter.fs./2;

figure;
if parameter.imagerange == 0
    imagesc(T,F,specData);
else
    imagesc(T,F,specData,parameter.imagerange);
end
axis xy;
colorbar;
title(parameter.name)