%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Different cosine function
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;

t=(0:1:512)/256;

subplot(2,2,1)
w=1;theta=0; ampl=1;
f=ampl*sin(2*pi*(w*t-theta));		
plot(t,f)               
axis([0,2,-1.6,1.6])
%xlabel('time t')
set(gca,'xtick',[])
title('\omega=1, \theta=0, A=1')
                        
subplot(2,2,2)
w=3; theta=0; ampl=1;
f=ampl*sin(2*pi*(w*t-theta));
plot(t,f)               
axis([0,2,-1.6,1.6])
%xlabel('time t')
set(gca,'xtick',[])
title('\omega=3, \theta=0, A=1')
                        
                        
subplot(2,2,3)
w=1; theta=-0.25; ampl=1.4;
f=ampl*sin(2*pi*(w*t-theta));	
plot(t,f)               
axis([0,2,-1.6,1.6])
%xlabel('time t')
title('\omega=1, \theta=0.25, A=1.4')
                        
subplot(2,2,4)
w=3; theta=0.5; ampl=0.8;
f=ampl*sin(2*pi*(w*t-theta));	
plot(t,f)               
axis([0,2,-1.6,1.6])
%xlabel('time t')
title('\omega=3, \theta=0.5, A=0.8')


printPaperPosition = [1   10   24  8]; %[left, bottom, width, height]
printFile = 'Signal_Sine_figure';
set(gcf,'PaperPosition',printPaperPosition); 
print('-dtiff',strcat(printFile));
