%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Approximation of Fourier transform by DFT of chirp function 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all hidden;

a=0;b=2;N=1280;t = a:(1/N)*(b-a):b-(1/(N*(b-a))); 
g=sin(6*pi*t.*t);		
                              
%[w,ghut,wmin,wmax]=ctft(a,b,N,t,g,0,128,1);
[w,ghut,wmin,wmax]=ctft(a,b,N,t,g,0,50,10);

printPaperPosition = [1   10   28  20]; %[left, bottom, width, height]

figure;
subplot(4,1,1)
plot(t,g)               
axis([a,b,-1.5,1.5])
xlabel('time t')

subplot(4,1,2)
plot(w,abs(ghut(wmin:wmax)))  
axis([0,50,0,0.3])
xlabel('frequency \omega')

T = 1/50;
a=0;b=2;N=b*(1/T);t = a:(1/N)*(b-a):b-(1/(N*(b-a))); 
g=(sin(6*pi*t.*t));		
ghut = T*fft(g);
subplot(4,1,3)
%plot(abs(ghut))
k_axis = (0:N-1);
stem(k_axis,abs(ghut),'.r')  
axis([1,100,0,0.3])
xlabel('index k')

T = 1/25;
a=0;b=2;N=b*(1/T);t = a:(1/N)*(b-a):b-(1/(N*(b-a))); 
g=(sin(6*pi*t.*t));		
ghut = T*fft(g);
subplot(4,1,4)
k_axis = (0:N-1);
stem(k_axis,abs(ghut),'.r')  
%plot(abs(ghut))  
axis([1,100,0,0.3])
xlabel('index k')

printFile = 'FourierDFT_Chirp_figure';
set(gcf,'PaperPosition',printPaperPosition); 
print('-dtiff',strcat(printFile));
