%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Sinus subsequent and Fourier transform
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all hidden;

a=0;b=10;N=1024;t = a:(1/N)*(b-a):b-(1/(N*(b-a)));

t1=t(1:512);
t2=t(513:1024);

f1=sin(2*pi*t1);
f2=0.7*sin(10*pi*t1);
g = [f1 f2];
                              
[w,ghut,wmin,wmax]=ctft(a,b,N,t,g,0,7,16);

figure;

subplot(2,1,1)
plot(t,g)               
axis([a,b,-2.2,2.2])
xlabel('Time t')
%title('f(t)=sin(2*\pi*t)+sin(10*\pi*t)')

subplot(2,1,2)
plot(w,abs(ghut(wmin:wmax)))  
%plot(w,abs(ghut(wmin:wmax)).^2)  
xlabel('Frequency \omega')
%title('Spectral energy density |F(f)|^2')

printPaperPosition = [1   10   22  14]; %[left, bottom, width, height]
printFile = 'FourierCT_Sine2_figure';
set(gcf,'PaperPosition',printPaperPosition); 
print('-dtiff',strcat(printFile));

% figure;
% subplot(2,1,1)
% plot(t,g)               
% axis([a,b,-2.2,2.2])
% xlabel('Time t')
% printPaperPosition = [1   10   22  10]; %[left, bottom, width, height]
% printFile = 'fig_fourier_CT_sine2_t';
% set(gcf,'PaperPosition',printPaperPosition); 
% print('-dtiff',strcat(printFile));
%                                   
% figure;
% subplot(2,1,1)
% plot(w,abs(ghut(wmin:wmax)))  
% xlabel('Frequency \omega')
% %axis([0,7,0,2.9])
% printPaperPosition = [1   10   22  10]; %[left, bottom, width, height]
% printFile = 'fig_fourier_CT_sine2_o';
% set(gcf,'PaperPosition',printPaperPosition); 
% print('-dtiff',strcat(printFile));

%% Sonification

N = 22050;
b = 1;
t = 0:(1/N):b;

p = 440;

g= [0.5*sin(p*2*pi*t), 0.5*sin(p*5/4*2*pi*t)];

wavwrite(g, 22050,16, 'FourierCT_Sine2_Audio.wav')
wavplay(g,22050)

                        