%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Dirac sequence and Fourier transform
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all hidden;

figure;
a=-1.2;b=1.2;N=512;t = a:(1/N)*(b-a):b-(1/(N*(b-a))); 
alpha=2;
g1=5*alpha*(2*pi)^(-1/2)*pi^(-1/4)*(exp((-2*pi*(alpha*t).^2)/2));		
alpha=4;
g2=5*alpha*(2*pi)^(-1/2)*pi^(-1/4)*(exp((-2*pi*(alpha*t).^2)/2));		
alpha=6;
g3=5*alpha*(2*pi)^(-1/2)*pi^(-1/4)*(exp((-2*pi*(alpha*t).^2)/2));		

%g=pi^(-1/4)*(exp(-(t.*t)/2));		
                              
[w,g1hut,wmin,wmax]=ctft(a,b,N,t,g1,-4,4,8);
[w,g2hut,wmin,wmax]=ctft(a,b,N,t,g2,-4,4,8);
[w,g3hut,wmin,wmax]=ctft(a,b,N,t,g3,-4,4,8);

subplot(3,2,1)
plot(t,g1)
axis([a,b,0,10])
%title('Dirac sequence f_1, f_2, f_3,...')

subplot(3,2,2)
plot(w,abs(g1hut(wmin:wmax)))  
axis([-4,4,0,2])
%title('Absolute values |F(f_1)|, |F(f_2)|, |F(f_3)|,... ')

subplot(3,2,3)
plot(t,g2)
axis([a,b,0,10])
subplot(3,2,4)
plot(w,abs(g2hut(wmin:wmax)))  
axis([-4,4,0,2])

subplot(3,2,5)
plot(t,g3)
%xlabel('Time t')
axis([a,b,0,10])
subplot(3,2,6)
plot(w,abs(g3hut(wmin:wmax)))  
axis([-4,4,0,2])
%xlabel('Frequency \omega')

printPaperPosition = [1   10   22  14]; %[left, bottom, width, height]
printFile = 'FourierCT_DiracDeltaSequence_figure';
set(gcf,'PaperPosition',printPaperPosition); 
print('-dtiff',strcat(printFile));