%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Chrip function and Fourier transform
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear;
close all hidden;

a=0;b=2;N=1024;t = a:(1/N)*(b-a):b-(1/(N*(b-a))); 
g=sin(20*pi*t.*t);		
                              
[w,ghut,wmin,wmax]=ctft(a,b,N,t,g,-120,120,4);

subplot(2,1,1)
plot(t,g)               
axis([a,b,-1.5,1.5])
xlabel('Time t')
%title('Chirp signal f(t)=sin(50*pi*t^2) on the interval [0:2]')

subplot(2,1,2)
plot(w,abs(ghut(wmin:wmax)))  
%plot(w,abs(ghut(wmin:wmax)).^2)  
xlabel('Frequency \omega')
%title('Spectral energy density |F(f)|^2')  
axis([0,60,0,0.15]);


printPaperPosition = [1   10   22  14]; %[left, bottom, width, height]
printFile = 'FourierCT_Chirp_figure';
set(gcf,'PaperPosition',printPaperPosition); 
print('-dtiff',strcat(printFile));

                        
                        
                        
                        